/*
 * Decompiled with CFR 0.152.
 */
package net.abumarkub.midi;

import java.applet.AppletContext;
import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import net.abumarkub.midi.MIDIDevice;
import net.abumarkub.midi.MIDIDeviceInfo;
import net.abumarkub.midi.MIDIMessage;

public class MIDIAccess {
    protected ArrayList<MIDIDevice> _inputs;
    protected ArrayList<MIDIDevice> _outputs;
    private ArrayList<MIDIDeviceInfo> _inputInfos;
    private ArrayList<MIDIDeviceInfo> _outputInfos;
    private ArrayList<MIDIDevice> _synths;
    private ArrayList<MIDIDevice> _sequencers;
    private ArrayList<MIDIDevice> _otherDevices;
    private AppletContext _context;
    private Object[] _inputInfosArray;
    private Object[] _outputInfosArray;

    public MIDIAccess(AppletContext context) {
        this._context = context;
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        this._inputs = new ArrayList();
        this._outputs = new ArrayList();
        this._inputInfos = new ArrayList();
        this._outputInfos = new ArrayList();
        this._synths = new ArrayList();
        this._sequencers = new ArrayList();
        this._otherDevices = new ArrayList();
        for (int i = 0; i < infos.length; ++i) {
            MIDIDevice midiDevice;
            Boolean available;
            String type;
            MidiDevice device;
            try {
                device = MidiSystem.getMidiDevice(infos[i]);
            }
            catch (MidiUnavailableException e) {
                System.out.println("could not get device " + infos[i]);
                continue;
            }
            int numRecv = device.getMaxReceivers();
            int numTrans = device.getMaxTransmitters();
            if (numRecv == -1 && numTrans == -1) {
                if (device instanceof Synthesizer) {
                    type = "synth";
                    available = this.checkDeviceAvailability(device);
                    if (!available.booleanValue()) continue;
                    this._synths.add(new MIDIDevice(device, this._synths.size(), type, this._context));
                    continue;
                }
                if (device instanceof Sequencer) {
                    type = "sequencer";
                    available = this.checkDeviceAvailability(device);
                    if (!available.booleanValue()) continue;
                    this._sequencers.add(new MIDIDevice(device, this._sequencers.size(), type, this._context));
                    continue;
                }
                type = "other";
                available = this.checkDeviceAvailability(device);
                if (!available.booleanValue()) continue;
                this._otherDevices.add(new MIDIDevice(device, this._otherDevices.size(), type, this._context));
                continue;
            }
            if (numRecv == 0) {
                type = "input";
                available = this.checkDeviceAvailability(device);
                if (!available.booleanValue()) continue;
                midiDevice = new MIDIDevice(device, this._inputs.size(), type, this._context);
                this._inputs.add(midiDevice);
                this._inputInfos.add(midiDevice.info);
                continue;
            }
            if (numTrans != 0) continue;
            type = "output";
            available = this.checkDeviceAvailability(device);
            if (!available.booleanValue()) continue;
            midiDevice = new MIDIDevice(device, this._outputs.size(), type, this._context);
            this._outputs.add(midiDevice);
            this._outputInfos.add(midiDevice.info);
        }
        this._inputInfosArray = this._inputInfos.toArray();
        this._outputInfosArray = this._outputInfos.toArray();
    }

    public boolean closeInputs() {
        for (MIDIDevice device : this._inputs) {
            device.close();
        }
        return true;
    }

    public boolean closeOutputs() {
        for (MIDIDevice device : this._outputs) {
            device.close();
        }
        return true;
    }

    public MIDIDevice getInput(MIDIDeviceInfo info) {
        MIDIDevice device = this._inputs.get(info.id);
        if (device.open()) {
            return device;
        }
        return null;
    }

    public MIDIDevice getOutput(MIDIDeviceInfo info) {
        MIDIDevice device = this._outputs.get(info.id);
        if (device.open()) {
            return device;
        }
        return null;
    }

    public Object[] enumerateInputs() {
        return this._inputInfosArray;
    }

    public Object[] enumerateOutputs() {
        return this._outputInfosArray;
    }

    public MIDIMessage createMIDIMessage(int command, int channel, int data1, int data2, int timeStamp) {
        return new MIDIMessage(command, channel, data1, data2, Long.parseLong("" + timeStamp));
    }

    private boolean checkDeviceAvailability(MidiDevice device) {
        if (device.isOpen()) {
            try {
                device.close();
                return true;
            }
            catch (Exception e) {
                System.out.println("MidiDevices.checkDevice() can not close device " + device.getDeviceInfo().getName() + " " + e);
                return false;
            }
        }
        try {
            device.open();
        }
        catch (MidiUnavailableException e) {
            System.out.println("MidiDevices.checkDevice() can not open device " + device.getDeviceInfo().getName() + " " + e);
            return false;
        }
        device.close();
        return true;
    }
}

