/*
 * Decompiled with CFR 0.152.
 */
package net.abumarkub.midi;

import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;
import net.abumarkub.midi.MIDIAccess;
import net.abumarkub.midi.MIDISequencer;

public class MIDIApplet
extends Applet {
    private AppletContext _context;
    private MIDIAccess _midiAccess;
    private MIDISequencer _midiSequencer;
    private Boolean _match;
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        MIDIApplet midiApplet = new MIDIApplet();
        midiApplet.init();
    }

    public synchronized void init() {
        int requiredVersion;
        String javaVersion = System.getProperty("java.version");
        int currentVersion = this.getVersionAsNumber(javaVersion);
        this._match = currentVersion >= (requiredVersion = this.getVersionAsNumber(this.getParameter("minJavaVersion")));
        System.out.println("[init] MIDIBridge 0.6.3 Java Version OK: " + this._match);
    }

    public void start() {
        this._context = this.getAppletContext();
        if (this._match.booleanValue()) {
            this._midiAccess = new MIDIAccess(this._context);
            this._midiSequencer = new MIDISequencer(this._context);
        }
        System.out.println("[start] " + this._context.toString() + " : " + System.getProperty("java.version") + " : " + System.getProperty("java.vendor"));
        String url = this._match != false ? "javascript:midiBridge.ready()" : "javascript:midiBridge.error('Please update your Java plugin (your version: " + System.getProperty("java.version") + " required version: " + this.getParameter("minJavaVersion") + ")')";
        try {
            this._context.showDocument(new URL(url));
        }
        catch (MalformedURLException me) {
            System.out.println(me);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void stop() {
        this._midiAccess.closeInputs();
        this._midiAccess.closeOutputs();
        this._midiSequencer.close();
        this._context = null;
        System.gc();
        System.out.println("[stop]");
    }

    public void destroy() {
        System.gc();
        System.runFinalization();
        System.out.println("[destroy]");
    }

    public boolean ready() {
        return true;
    }

    public MIDIAccess getMIDIAccess() {
        return this._midiAccess;
    }

    public MIDISequencer getSequencer() {
        return this._midiSequencer;
    }

    private int getVersionAsNumber(String version) {
        String tmp = version.substring(0, 1);
        tmp = tmp + version.substring(2, 3);
        return Integer.parseInt(tmp);
    }
}

