/*
 * Decompiled with CFR 0.152.
 */
package net.abumarkub.midi;

import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import net.abumarkub.midi.MIDIDeviceInfo;
import net.abumarkub.midi.MIDIMessage;
import netscape.javascript.JSObject;

public class MIDIDevice
implements Receiver {
    private MidiDevice _device;
    private MidiDevice.Info _deviceInfo;
    private Receiver _receiver;
    private Transmitter _transmitter;
    private Transmitter _transmitter2;
    public MIDIDeviceInfo info;
    private AppletContext _context;
    private JSObject _jsEventListener;
    public int id;
    public String deviceType;
    public String deviceName;
    public String deviceManufacturer;
    public String deviceVersion;
    public String deviceDescription;

    public MIDIDevice(MidiDevice device, int index, String type, AppletContext context) {
        this._device = device;
        this._deviceInfo = device.getDeviceInfo();
        this._context = context;
        this.info = new MIDIDeviceInfo(index, type, this._deviceInfo);
        this.id = index;
        this.deviceType = type;
        this.deviceName = this.info.deviceName;
        this.deviceManufacturer = this.info.deviceManufacturer;
        this.deviceVersion = this.info.deviceVersion;
        this.deviceDescription = this.info.deviceDescription;
        System.out.println("[" + type + "]" + this.info.deviceName);
        this._receiver = null;
        this._transmitter = null;
        this._transmitter2 = null;
    }

    private void sendMessageViaContext(String url) {
        try {
            this._context.showDocument(new URL(url));
        }
        catch (MalformedURLException me) {
            System.out.println(me);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void close() {
        if (this._receiver != null) {
            this._receiver.close();
        }
        if (this._transmitter != null) {
            this._transmitter.close();
        }
        if (this._transmitter2 != null) {
            this._transmitter2.close();
        }
        if (this._device.isOpen()) {
            this._device.close();
        }
    }

    public boolean open() {
        if (!this._device.isOpen()) {
            try {
                this._device.open();
            }
            catch (MidiUnavailableException e) {
                System.out.println("error opening device: " + e);
                return false;
            }
        }
        if (this.info.deviceType.equals("input")) {
            try {
                this._transmitter = this._device.getTransmitter();
                this._transmitter.setReceiver(this);
            }
            catch (MidiUnavailableException e) {
                System.out.println("error getting transmitter: " + e);
                return false;
            }
        }
        if (this.info.deviceType.equals("output")) {
            try {
                this._receiver = this._device.getReceiver();
            }
            catch (MidiUnavailableException e) {
                System.out.println("error getting receiver: " + e);
                return false;
            }
        }
        return true;
    }

    public boolean addEventListener(String id) {
        if (this.deviceType.equals("output")) {
            System.out.println("Can not add eventlistener to an output");
            return false;
        }
        if (id.equals("midimessage")) {
            if (this._transmitter == null) {
                try {
                    this._transmitter = this._device.getTransmitter();
                }
                catch (MidiUnavailableException e) {
                    System.out.println("Device " + this.deviceName + " could not open a transmitter " + e);
                    return false;
                }
            }
            this._transmitter.setReceiver(this);
            return true;
        }
        return false;
    }

    public boolean addEventListener(String id, JSObject eventListener) {
        this._jsEventListener = eventListener;
        if (this.deviceType.equals("output")) {
            System.out.println("Can not add eventlistener to an output");
            return false;
        }
        if (id.equals("midimessage")) {
            if (this._transmitter == null) {
                try {
                    this._transmitter = this._device.getTransmitter();
                }
                catch (MidiUnavailableException e) {
                    System.out.println("Device " + this.deviceName + " could not open a transmitter " + e);
                    return false;
                }
            }
            this._transmitter.setReceiver(this);
            return true;
        }
        return false;
    }

    public boolean setDirectOutput(MIDIDevice device) {
        if (this.deviceType.equals("output")) {
            System.out.println("Can not add an output to an output!");
            return false;
        }
        System.out.println("setDirectOutput: " + device.deviceName);
        if (this._receiver != null) {
            this._receiver.close();
        }
        this._receiver = device.getReceiver();
        if (this._receiver == null) {
            return false;
        }
        if (this._transmitter2 == null) {
            try {
                this._transmitter2 = this._device.getTransmitter();
            }
            catch (MidiUnavailableException e) {
                System.out.println("Device " + this.deviceName + " could not open a transmitter " + e);
                return false;
            }
        }
        this._transmitter2.setReceiver(this._receiver);
        return true;
    }

    public void removeDirectOutput() {
        if (this._transmitter2 != null) {
            this._transmitter2.close();
        }
        if (this._receiver != null) {
            this._receiver.close();
        }
        this._transmitter2 = null;
        this._receiver = null;
    }

    public boolean hasDirectOutput() {
        return this._receiver != null;
    }

    public MidiDevice getDevice() {
        return this._device;
    }

    public Receiver getReceiver() {
        return this._receiver;
    }

    public Transmitter getTransmitter() {
        return this._transmitter;
    }

    public boolean sendMIDIMessage(MIDIMessage message) {
        if (this.deviceType.equals("input")) {
            System.out.println("Can not send a MIDI message to an input!");
            return false;
        }
        ShortMessage sm = new ShortMessage();
        try {
            sm.setMessage(message.command, message.channel, message.data1, message.data2);
            this._receiver.send(sm, message.timeStamp);
        }
        catch (InvalidMidiDataException e) {
            System.out.println("error sending MIDI message: " + e);
            return false;
        }
        catch (NullPointerException e) {
            System.out.println("error sending MIDI message: " + e);
            return false;
        }
        return true;
    }

    public boolean sendMIDIMessage(int command, int channel, int data1, int data2, int timeStamp) {
        if (this.deviceType.equals("input")) {
            System.out.println("Can not send a MIDI message to an input!");
            return false;
        }
        ShortMessage sm = new ShortMessage();
        try {
            sm.setMessage(command, channel, data1, data2);
            this._receiver.send(sm, timeStamp);
        }
        catch (InvalidMidiDataException e) {
            System.out.println("error sending MIDI message: " + e);
            return false;
        }
        catch (NullPointerException e) {
            System.out.println("error sending MIDI message: " + e);
            return false;
        }
        return true;
    }

    public void send(MidiMessage message, long timeStamp) {
        if (message instanceof ShortMessage) {
            ShortMessage tmp = (ShortMessage)message;
            MIDIMessage msg = new MIDIMessage(tmp, timeStamp);
            Object[] args = new Object[]{msg};
            this._jsEventListener.call("listener", args);
        }
    }

    public String toString() {
        return this.info.toString();
    }
}

