/*
 * Decompiled with CFR 0.152.
 */
package net.abumarkub.midi;

import javax.sound.midi.ShortMessage;
import net.abumarkub.midi.MIDIData;

public class MIDIMessage {
    public int status;
    public int channel;
    public int data1;
    public int data2;
    public int command;
    public Long timeStamp = -1L;

    public MIDIMessage(ShortMessage sm, Long ts) {
        this.command = sm.getCommand();
        this.channel = sm.getChannel();
        this.data1 = sm.getData1();
        this.data2 = sm.getData2();
        this.status = sm.getStatus();
        this.timeStamp = ts;
        if (this.command == 144 && this.data2 == 0) {
            this.status = 128 + this.channel;
            this.command = 128;
        }
    }

    public MIDIMessage(int command_, int channel_, int data1_, int data2_, Long ts) {
        this.command = command_;
        this.channel = channel_;
        this.data1 = data1_;
        this.data2 = data2_;
        this.status = command_ + channel_;
        this.timeStamp = ts;
        if (this.command == 144 && this.data2 == 0) {
            this.status = 128 + this.channel;
            this.command = 128;
        }
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        if (this.command == 176) {
            message.append("CMD:");
            message.append(MIDIData.getCommand(this.command));
            message.append(" CHAN:");
            message.append(this.channel);
            message.append(" ");
            message.append(MIDIData.getControlChangeMessage(this.data1));
            message.append(":");
            message.append(this.data2);
            message.append(" TIME:");
            message.append(this.timeStamp);
        } else if (this.command == 128 || this.command == 144) {
            message.append("CMD:");
            message.append(MIDIData.getCommand(this.command));
            message.append(" CHAN:");
            message.append(this.channel);
            message.append(" NOTE:");
            message.append(this.data1);
            message.append(" VELOCITY:");
            message.append(this.data2);
            message.append(" TIME:");
            message.append(this.timeStamp);
        } else {
            message.append("CMD:");
            message.append(MIDIData.getCommand(this.command));
            message.append(" CHAN:");
            message.append(this.channel);
            message.append(" DATA1:");
            message.append(this.data1);
            message.append(" DATA2:");
            message.append(this.data2);
            message.append(" TIME:");
            message.append(this.timeStamp);
        }
        return message.toString();
    }

    public int[] toArray() {
        int[] message = new int[]{this.command, this.channel, this.data1, this.data2, this.status};
        return message;
    }
}

