/*
 * Decompiled with CFR 0.152.
 */
package net.abumarkub.midi;

import java.applet.AppletContext;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import net.abumarkub.midi.MIDIDevice;
import net.abumarkub.midi.MIDIMessage;
import netscape.javascript.JSObject;
import org.apache.commons.codec.binary.Base64;

public class MIDISequencer
implements Receiver,
MetaEventListener {
    private Sequence _sequence;
    private Sequencer _sequencer;
    private Transmitter _transmitter;
    private Transmitter _transmitter2;
    private Receiver _receiver;
    private AppletContext _context;
    private JSObject _jsMIDIEventListener;
    private JSObject _jsMetaEventListener;
    private boolean _hasMetaEventListener;

    public MIDISequencer(AppletContext context) {
        this._context = context;
        try {
            this._sequencer = MidiSystem.getSequencer(false);
        }
        catch (MidiUnavailableException e) {
            System.out.println(e);
        }
        this._receiver = null;
        this._transmitter = null;
        this._transmitter2 = null;
    }

    private void sendMessageViaContext(String url) {
        try {
            this._context.showDocument(new URL(url));
        }
        catch (MalformedURLException me) {
            System.out.println(me);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean addEventListener(String id) {
        if (id.equals("midimessage")) {
            if (this._transmitter == null) {
                try {
                    this._transmitter = this._sequencer.getTransmitter();
                }
                catch (MidiUnavailableException e) {
                    System.out.println("Sequencer could not open a transmitter " + e);
                    return false;
                }
            }
            this._transmitter.setReceiver(this);
            return true;
        }
        if (id.equals("metamessage")) {
            if (!this._hasMetaEventListener) {
                this._hasMetaEventListener = this._sequencer.addMetaEventListener(this);
            }
            return true;
        }
        return false;
    }

    public boolean addEventListener(String id, JSObject eventListener) {
        if (id.equals("midimessage")) {
            if (this._transmitter == null) {
                try {
                    this._transmitter = this._sequencer.getTransmitter();
                }
                catch (MidiUnavailableException e) {
                    System.out.println("Sequencer could not open a transmitter " + e);
                    return false;
                }
            }
            this._jsMIDIEventListener = eventListener;
            this._transmitter.setReceiver(this);
            return true;
        }
        if (id.equals("metamessage")) {
            if (!this._hasMetaEventListener) {
                this._hasMetaEventListener = this._sequencer.addMetaEventListener(this);
            }
            this._jsMetaEventListener = eventListener;
            return true;
        }
        return false;
    }

    public Sequence loadBase64String(String data) {
        this._sequence = null;
        byte[] decoded = Base64.decodeBase64(data);
        ByteArrayInputStream input = new ByteArrayInputStream(decoded);
        try {
            this._sequence = MidiSystem.getSequence(input);
            this.loadSequence(this._sequence);
        }
        catch (Exception e) {
            System.out.println("loading: " + e);
        }
        return this._sequence;
    }

    public Sequence playBase64String(String data) {
        this.loadBase64String(data);
        this.play();
        return this._sequence;
    }

    public Sequence loadMidiFile(String url) {
        FileInputStream is = null;
        this._sequence = null;
        try {
            is = new FileInputStream(url);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            this._sequence = MidiSystem.getSequence(is);
            this.loadSequence(this._sequence);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return this._sequence;
    }

    public Sequence playMidiFile(String url) {
        this.loadMidiFile(url);
        this.play();
        return this._sequence;
    }

    public void close() {
        if (this._sequencer.isOpen()) {
            this._sequencer.stop();
            this._sequencer.close();
        }
        if (this._transmitter != null) {
            this._transmitter.close();
        }
        if (this._transmitter2 != null) {
            this._transmitter2.close();
        }
        if (this._receiver != null) {
            this._receiver.close();
        }
    }

    private void loadSequence(Sequence seq) {
        try {
            this._sequencer.open();
        }
        catch (MidiUnavailableException e) {
            System.out.println(e);
        }
        try {
            this._sequencer.setSequence(seq);
        }
        catch (InvalidMidiDataException e) {
            System.out.println(e);
        }
    }

    public void send(MidiMessage message, long timeStamp) {
        timeStamp = this._sequencer.getMicrosecondPosition();
        if (message instanceof ShortMessage) {
            ShortMessage tmp = (ShortMessage)message;
            MIDIMessage msg = new MIDIMessage(tmp, timeStamp);
            Object[] args = new Object[]{msg};
            this._jsMIDIEventListener.call("listener", args);
        }
    }

    public void meta(MetaMessage meta) {
        Object[] args = new Object[]{meta};
        this._jsMetaEventListener.call("listener", args);
    }

    public Sequence getSequence() {
        return this._sequence;
    }

    public boolean setDirectOutput(MIDIDevice device) {
        System.out.println("setDirectOutput: " + device.deviceName);
        if (this._receiver != null) {
            this._receiver.close();
        }
        this._receiver = device.getReceiver();
        if (this._receiver == null) {
            return false;
        }
        if (this._transmitter2 == null) {
            try {
                this._transmitter2 = this._sequencer.getTransmitter();
            }
            catch (MidiUnavailableException e) {
                System.out.println("Sequencer could not open a transmitter " + e);
                return false;
            }
        }
        this._transmitter2.setReceiver(this._receiver);
        return true;
    }

    public void removeDirectOutput() {
        if (this._transmitter2 != null) {
            this._transmitter2.close();
        }
        if (this._receiver != null) {
            this._receiver.close();
        }
        this._transmitter2 = null;
        this._receiver = null;
    }

    public boolean hasDirectOutput() {
        return this._receiver != null;
    }

    public void play() {
        if (this._sequencer.isOpen()) {
            this._sequencer.start();
        }
    }

    public void pause() {
        if (this._sequencer.isOpen()) {
            this._sequencer.stop();
        }
    }

    public void stop() {
        if (this._sequencer.isOpen()) {
            this._sequencer.setMicrosecondPosition(0L);
            this._sequencer.stop();
        }
    }

    public Long getMicrosecondPosition() {
        return this._sequencer.getMicrosecondPosition();
    }

    public void setMicrosecondPosition(int pos) {
        this._sequencer.setMicrosecondPosition(Long.parseLong("" + pos));
    }

    public float getTempoInBPM() {
        return this._sequencer.getTempoInBPM();
    }

    public void setTempoInBPM(int bpm) {
        this._sequencer.setTempoInBPM(Float.parseFloat("" + bpm));
    }

    public float getTempoFactor() {
        return this._sequencer.getTempoFactor();
    }

    public void setTempoFactor(float factor) {
        this._sequencer.setTempoFactor(factor);
    }

    public void muteTrack(int index) {
        this._sequencer.setTrackMute(index, true);
    }

    public void unmuteTrack(int index) {
        this._sequencer.setTrackMute(index, false);
    }

    public void createNewSequence() {
        this._sequence.getMicrosecondLength();
        this._sequence.getTickLength();
    }
}

